﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Azyobuzi.りすにんぐついったー.Properties;

namespace Azyobuzi.りすにんぐついったー
{
    public partial class ListeningMessender : Form //「Messenger」じゃないよ「Messender」だよ！
    {
        public ListeningMessender()
        {
            InitializeComponent();
            this.Icon = Resources.mainIco;
        }
        
        private void helpBtn_Click(object sender, EventArgs e)
        {
            Program.ShowWiki("ListeningMessender");
        }

        private void sendBtn_Click(object sender, EventArgs e)
        {
            if (textBox1.Text.Trim().Length != 0 || textBox2.Text.Trim().Length != 0)
            {
                Program.m_form.tweetBox.Text = string.Format(SettingsXml.Instance.template, textBox1.Text, textBox2.Text, "", "", "");
                if (!Program.m_form.PostTweet(false))
                {
                    MessageBox.Show("投稿できませんでした。内容を確認してください。", "エラー", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                textBox1.Clear(); textBox2.Clear();
            }
            else
            {
                MessageBox.Show("曲名またはアーティスト名を入力してください。", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        //インスタンスを作成せずログを表示させるメソッド
        private static ListeningMessender f = new ListeningMessender();
        public static void ShowForm()
        {
            f.Location = SettingsXml.Instance.messender_location;
            f.Show();
        }

        private void ListeningMessender_FormClosing(object sender, FormClosingEventArgs e)
        {
            SettingsXml.Instance.messender_location = this.Location;
            e.Cancel = true;
            this.Hide();
        }
    }
}
